# GraphNav Extension

GraphNav is a premium browser extension that visualizes any website's sitemap as an interactive D3.js tree graph.

## Features

- **Dynamic Visualization**: Automatically parses the current page's links and builds a hierarchical tree structure.
- **Intelligent Grouping**: Paths like `/items/pants` and `/items/shirts` are smartly grouped under a common `items` node.
- **Interactive Navigation**: Click any node to navigate directly to that page in your current tab.
- **Premium Design**: Sleek dark-mode interface with glassmorphism and smooth animations.
- **Zoom & Pan**: Easily explore large sitemaps using mouse wheel or drag.

## How to Install

1. Open your browser (Chrome/Edge/Brave) and navigate to `chrome://extensions`.
2. Enable **Developer mode** in the top right corner.
3. Click **Load unpacked**.
4. Select this project folder (`graph-nav`).
5. Open any website and click the GraphNav icon in your extension bar!

## Technologies

- **D3.js**: High-performance data visualization.
- **Manifest V3**: Using latest browser extension standards.
- **Vanilla CSS**: Custom premium styling with glassmorphism effects.
